<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['task_id'])) {
    die("Uzdevums nav norādīts.");
}

$task_id = intval($_GET['task_id']);

// Pārbaudām, vai lietotājam ir piekļuve uzdevumam
$stmt = $pdo->prepare("SELECT * FROM tasks WHERE id = ? AND calendar_id IN (SELECT id FROM calendars WHERE user_id = ?)");
$stmt->execute([$task_id, $_SESSION['user_id']]);
$task = $stmt->fetch();

if (!$task) {
    die("Jums nav piekļuves šim uzdevumam.");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = trim($_POST['title']);
    $description = trim($_POST['description']);
    $start_time = trim($_POST['start_time']);
    $end_time = trim($_POST['end_time']);

    if (empty($title) || empty($start_time) || empty($end_time)) {
        die("Lūdzu aizpildiet visus laukus.");
    }

    // Formatējam datumu uz MySQL formātu
    $start_time = date("Y-m-d H:i:s", strtotime($start_time));
    $end_time = date("Y-m-d H:i:s", strtotime($end_time));

    // Atjauninām uzdevumu datubāzē
    $stmt = $pdo->prepare("UPDATE tasks SET title = ?, description = ?, start_time = ?, end_time = ? WHERE id = ?");
    $stmt->execute([$title, $description, $start_time, $end_time, $task_id]);

    header("Location: dashboard.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rediģēt uzdevumu</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
<?php include 'header.php'; ?>

<h1>Rediģēt uzdevumu: <?php echo htmlspecialchars($task['title']); ?></h1>
<form method="POST">
    <label for="title">Nosaukums:</label>
    <input type="text" name="title" id="title" value="<?php echo htmlspecialchars($task['title']); ?>" required>

    <label for="description">Apraksts:</label>
    <textarea name="description" id="description"><?php echo htmlspecialchars($task['description']); ?></textarea>

    <label for="start_time">Sākuma laiks:</label>
    <input type="text" name="start_time" id="start_time" value="<?php echo htmlspecialchars(date("Y-m-d H:i", strtotime($task['start_time']))); ?>" required>

    <label for="end_time">Beigu laiks:</label>
    <input type="text" name="end_time" id="end_time" value="<?php echo htmlspecialchars(date("Y-m-d H:i", strtotime($task['end_time']))); ?>" required>

    <button type="submit">Saglabāt izmaiņas</button>
</form>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    flatpickr("#start_time", {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true
    });

    flatpickr("#end_time", {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true
    });
</script>

<?php include 'footer.php'; ?>
</body>
</html>
